/*
 * Decompiled with CFR 0.152.
 */
class complexNumber {
    private double r;
    private double i;
    private double z;
    private double phi;

    complexNumber(complexNumber complexNumber2) {
        this.r = complexNumber2.getRealPart();
        this.i = complexNumber2.getImaginaryPart();
        this.z = complexNumber2.getPolLength();
        this.phi = complexNumber2.getPolAngle();
    }

    complexNumber(double d, double d2) {
        this.r = d;
        this.i = d2;
        this.calcPol();
    }

    complexNumber() {
        this.r = 0.0;
        this.i = 0.0;
        this.z = 0.0;
        this.phi = 0.0;
    }

    private void calcPol() {
        this.z = Math.sqrt(this.sqrabs());
        this.phi = this.z == 0.0 ? 0.0 : (Math.signum(this.i) + 1.0 - Math.abs(Math.signum(this.i))) * Math.acos(this.r / this.z);
    }

    private void calcKarth() {
        this.r = this.z * Math.cos(this.phi);
        this.i = this.z * Math.sin(this.phi);
    }

    public double getRealPart() {
        return this.r;
    }

    public double getImaginaryPart() {
        return this.i;
    }

    public double getPolLength() {
        return this.z;
    }

    public double getPolAngle() {
        return this.phi;
    }

    public void add(complexNumber complexNumber2) {
        double d = complexNumber2.getRealPart();
        double d2 = complexNumber2.getImaginaryPart();
        this.r += d;
        this.i += d2;
        this.calcPol();
    }

    public void sub(complexNumber complexNumber2) {
        double d = complexNumber2.getRealPart();
        double d2 = complexNumber2.getImaginaryPart();
        this.r -= d;
        this.i -= d2;
        this.calcPol();
    }

    public void mult(complexNumber complexNumber2) {
        double d = complexNumber2.getRealPart();
        double d2 = complexNumber2.getImaginaryPart();
        double d3 = this.r * d - this.i * d2;
        double d4 = this.r * d2 + this.i * d;
        this.r = d3;
        this.i = d4;
        this.calcPol();
    }

    public void div(complexNumber complexNumber2) {
        double d = complexNumber2.sqrabs();
        double d2 = complexNumber2.getRealPart();
        double d3 = complexNumber2.getImaginaryPart();
        double d4 = this.r * d2 + this.i * d3 / d;
        double d5 = this.i * d2 + this.r * d3 / d;
        this.r = d4;
        this.i = d5;
        this.calcPol();
    }

    public complexNumber conj() {
        return new complexNumber(this.r, -this.i);
    }

    public void sqr() {
        this.mult(this);
    }

    public void power(int n) {
        complexNumber complexNumber2 = new complexNumber(this);
        for (int i = 1; i < n; ++i) {
            this.mult(complexNumber2);
        }
    }

    public void power(double d) {
        this.log();
        this.mult(new complexNumber(d, 0.0));
        this.exp();
    }

    public double sqrabs() {
        return this.r * this.r + this.i * this.i;
    }

    public void exp() {
        double d = Math.exp(this.r);
        this.r = d * Math.cos(this.i);
        this.i = d * Math.sin(this.i);
        this.calcPol();
    }

    public double arg() {
        return Math.atan2(this.r, this.i);
    }

    public void log() {
        double d = Math.sqrt(this.r * this.r + this.i * this.i);
        double d2 = Math.atan2(this.i, this.r);
        if (d2 > Math.PI) {
            d2 -= Math.PI * 2;
        }
        this.r = Math.log(d);
        this.i = d2;
        this.calcPol();
    }

    public String toString() {
        return "r=" + this.r + " i=" + this.i;
    }
}

